/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GeneralizedRequest
implements ProductionTreeNode,
Propertized {
    public static final long UNSET_DATE = -9223372036854775708L;
    private long dueDate;
    private long releaseDate;
    private long startDate = Long.MAX_VALUE;
    private long endDate = Long.MIN_VALUE;
    private long plannedDuration;
    private double requestedQty;
    private double totalRequestedQty;
    private double completedQty;
    private double inPlanQty;
    private double outOfPlanQty;
    private double totalPlannedQty;
    private double totalCompletedQty;
    private String description;
    private ProductionTreeNode parent;
    private PropertySupport propertySupport;

    protected GeneralizedRequest(double requestedQty, long releaseDate, long dueDate) {
        this.releaseDate = releaseDate;
        this.dueDate = dueDate;
        this.requestedQty = requestedQty;
        this.inPlanQty = 0.0;
        this.outOfPlanQty = 0.0;
        this.completedQty = 0.0;
        this.description = "";
        this.propertySupport = new PropertySupport();
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public boolean isDueDateUnset() {
        return this.dueDate == -9223372036854775708L;
    }

    public void unsafeSetDueDate(long dueDate) {
        this.dueDate = dueDate;
    }

    public long getReleaseDate() {
        return this.releaseDate;
    }

    public void unsafeSetReleaseDate(long releaseDate) {
        this.releaseDate = releaseDate;
    }

    public boolean isReleaseDateUnset() {
        return this.releaseDate == -9223372036854775708L;
    }

    public double getAmount() {
        double retVal = this.getRequestedQty() - this.getPlannedQty();
        return retVal < 0.0 ? 0.0 : retVal;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    protected void unsafeSetStartDate(long startDate) {
        this.startDate = startDate;
    }

    protected void unsafeSetEndDate(long endDate) {
        this.endDate = endDate;
    }

    public double getRequestedQty() {
        return this.requestedQty;
    }

    public void unsafeSetRequestedQty(double requestedQty) {
        this.requestedQty = requestedQty;
    }

    public double getPlannedQty() {
        return this.getInPlanQty() + this.getOutOfPlanQty();
    }

    public double getInPlanQty() {
        return this.inPlanQty;
    }

    public double getOutOfPlanQty() {
        return this.outOfPlanQty;
    }

    public double getCompletedQty() {
        return this.completedQty;
    }

    public void setCompletedQty(double completedQty) {
        this.completedQty = completedQty;
    }

    public void unsafeSetInPlanQty(double inPlanQty) {
        this.inPlanQty = inPlanQty;
    }

    public long getPlannedDuration() {
        return this.plannedDuration;
    }

    protected void unsafeSetPlannedDuration(long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public double getTotalRequestedQty() {
        return this.totalRequestedQty;
    }

    protected void unsafeSetTotalRequestedQty(double totalRequestedQty) {
        this.totalRequestedQty = totalRequestedQty;
    }

    public double getTotalCompletedQty() {
        return this.totalCompletedQty;
    }

    protected void unsafeSetTotalCompletedQty(double totalCompletedQty) {
        this.totalCompletedQty = totalCompletedQty;
    }

    public double getTotalPlannedQty() {
        return this.totalPlannedQty;
    }

    protected void unsafeSetTotalPlannedQty(double totalPlannedQty) {
        this.totalPlannedQty = totalPlannedQty;
    }

    public double getPlannedRatio() {
        return this.getTotalPlannedQty() / this.getTotalRequestedQty();
    }

    @Override
    public ProductionTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void unsafeSetParent(ProductionTreeNode parent) {
        this.parent = parent;
    }

    public void unsafeSetOutOfPlanQty(double outOfPlanQty) {
        this.outOfPlanQty = outOfPlanQty;
    }

    public void setOutOfPlanQty(double outOfPlanQty) {
        this.unsafeSetOutOfPlanQty(outOfPlanQty);
        this.unsafeSetTotalPlannedQty(this.getPlannedQty());
        if (this.getParent() != null) {
            this.getParent().childChanged(this);
        }
    }

    public abstract void updateStartEnd();

    public abstract void updateSummaryData();

    @Override
    public void childChanged(ProductionTreeNode child) {
        this.updateSummaryData();
        this.updateStartEnd();
        if (this.getParent() != null) {
            this.getParent().childChanged(this);
        }
    }

    public static boolean isDateValid(long time) {
        return time != -9223372036854775708L && time != Long.MIN_VALUE && time != Long.MAX_VALUE;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setProperties(@Nullable Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }
}

